function svdlg(action, figList)

%     SVDLG     Save Dialog

% ======================================================
%   PROGRAM AIM : 
%         TO ASK USER TO SAVE EXISTING SYSTEM OR NOT
% ======================================================
%   USAGE :
%         1. svdlg('GFSfile')
% ======================================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI 
%   JULY 2009
%   COPYRIGHT RESERVED
% ======================================================

nit = action{1};
oldName=nit.Name;
% Call the standard question dialog box
ButtonPressed = questdlg(sprintf('Save changes to %s?', oldName), 'NIT Editor');

switch ButtonPressed
    
case 'Yes'
    % Closes all fuzzy windows and exits after saving changes to NIT
    if strcmp(nit.Name, 'Untitled')
        wrnit(nit);
    else
        wrnit(nit, nit.Name);
    end
    if ~isempty(figList) 
        delete(figList); 
    end

case 'No'
    % Closes all fuzzy windows and exits without saving changes to NIT
    if ~isempty(figList)
        delete(figList); 
    end
   
case 'Cancel'
    % Do nothing questdlg box closes automatically
    
end
